-- phpMyAdmin SQL Dump
-- version 5.2.1
-- https://www.phpmyadmin.net/
--
-- Host: 127.0.0.1:3306
-- Generation Time: Dec 16, 2025 at 10:06 PM
-- Server version: 8.2.0
-- PHP Version: 8.2.13

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `goldhldz_onlinedesign`
--

DELIMITER $$
--
-- Procedures
--
DROP PROCEDURE IF EXISTS `update_bank_account_balance`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `update_bank_account_balance` (IN `bank_account_id` INT)   BEGIN
    DECLARE new_balance DECIMAL(15,2);
    
    SELECT COALESCE(SUM(debit_amount) - SUM(credit_amount), 0) INTO new_balance
    FROM transactions 
    WHERE account_type = 'bank' 
      AND account_id = bank_account_id
      AND is_reversed = 0;
    
    UPDATE bank_accounts 
    SET current_balance = new_balance,
        updated_at = NOW()
    WHERE id = bank_account_id;
END$$

DROP PROCEDURE IF EXISTS `update_cash_box_balance`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `update_cash_box_balance` (IN `cash_box_id` INT)   BEGIN
    DECLARE new_balance DECIMAL(15,2);
    
    SELECT COALESCE(SUM(debit_amount) - SUM(credit_amount), 0) INTO new_balance
    FROM transactions 
    WHERE account_type = 'cash' 
      AND account_id = cash_box_id
      AND is_reversed = 0;
    
    UPDATE cash_boxes 
    SET current_balance = new_balance,
        updated_at = NOW()
    WHERE id = cash_box_id;
END$$

DROP PROCEDURE IF EXISTS `update_company_balance`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `update_company_balance` (IN `company_id` INT)   BEGIN
    DECLARE new_balance DECIMAL(15,2);
    
    SELECT COALESCE(SUM(credit_amount) - SUM(debit_amount), 0) INTO new_balance
    FROM transactions 
    WHERE account_type = 'company' 
      AND account_id = company_id
      AND is_reversed = 0;
    
    UPDATE companies 
    SET current_balance = new_balance,
        updated_at = NOW()
    WHERE id = company_id;
END$$

DROP PROCEDURE IF EXISTS `update_customer_balance`$$
CREATE DEFINER=`root`@`localhost` PROCEDURE `update_customer_balance` (IN `customer_id` INT)   BEGIN
    DECLARE new_balance DECIMAL(15,2);
    
    SELECT COALESCE(SUM(debit_amount) - SUM(credit_amount), 0) INTO new_balance
    FROM transactions 
    WHERE account_type = 'customer' 
      AND account_id = customer_id
      AND is_reversed = 0;
    
    UPDATE customers 
    SET current_balance = new_balance,
        updated_at = NOW()
    WHERE id = customer_id;
END$$

--
-- Functions
--
DROP FUNCTION IF EXISTS `calculate_account_balance`$$
CREATE DEFINER=`root`@`localhost` FUNCTION `calculate_account_balance` (`account_type_param` ENUM('customer','company','cash','bank'), `account_id_param` INT) RETURNS DECIMAL(15,2) DETERMINISTIC READS SQL DATA BEGIN
    DECLARE balance DECIMAL(15,2) DEFAULT 0.00;
    
    SELECT 
        COALESCE(SUM(debit_amount) - SUM(credit_amount), 0) INTO balance
    FROM transactions
    WHERE account_type = account_type_param 
      AND account_id = account_id_param
      AND is_reversed = 0;
    
    RETURN balance;
END$$

DELIMITER ;

-- --------------------------------------------------------

--
-- Table structure for table `activity_logs`
--

DROP TABLE IF EXISTS `activity_logs`;
CREATE TABLE IF NOT EXISTS `activity_logs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `action` varchar(50) NOT NULL,
  `entity_type` varchar(50) NOT NULL,
  `entity_id` int NOT NULL,
  `old_values` json DEFAULT NULL,
  `new_values` json DEFAULT NULL,
  `ip_address` varchar(45) DEFAULT NULL,
  `user_agent` text,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_activity_logs_user_id` (`user_id`),
  KEY `idx_activity_logs_entity` (`entity_type`,`entity_id`)
) ENGINE=MyISAM AUTO_INCREMENT=88 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Dumping data for table `activity_logs`
--

INSERT INTO `activity_logs` (`id`, `user_id`, `action`, `entity_type`, `entity_id`, `old_values`, `new_values`, `ip_address`, `user_agent`, `created_at`) VALUES
(87, 1, 'login', 'user', 1, NULL, '{\"ip\": \"::1\", \"user_agent\": \"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36\"}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '2025-12-16 21:45:42'),
(85, 1, 'create', 'company', 7, NULL, '{\"name\": \"دون شركب\", \"phone\": \"5548653\", \"address\": \"تعز المفرق\", \"opening_balance\": 1500}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '2025-12-15 12:24:23'),
(86, 1, 'login', 'user', 1, NULL, '{\"ip\": \"::1\", \"user_agent\": \"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36\"}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '2025-12-15 22:53:53'),
(84, 1, 'create', 'customer', 12, NULL, '{\"name\": \"احمد العامري\", \"phone\": \"784173938\", \"address\": \"تعز الحوبان\", \"opening_balance\": 5000}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '2025-12-15 12:23:08'),
(83, 1, 'create', 'cash_box', 7, NULL, '{\"name\": \"صندوق رقم 1\", \"opening_balance\": 2000}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '2025-12-15 09:22:26'),
(82, 1, 'create', 'bank_account', 20, NULL, '{\"name\": \"الحساب الرئيسي\", \"opening_balance\": 500000}', '::1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '2025-12-15 09:16:15');

-- --------------------------------------------------------

--
-- Table structure for table `bank_accounts`
--

DROP TABLE IF EXISTS `bank_accounts`;
CREATE TABLE IF NOT EXISTS `bank_accounts` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `bank_name` varchar(255) NOT NULL,
  `account_number` varchar(100) NOT NULL,
  `branch_name` varchar(255) DEFAULT NULL,
  `iban` varchar(50) DEFAULT NULL,
  `swift_code` varchar(20) DEFAULT NULL,
  `opening_balance` decimal(15,2) DEFAULT '0.00',
  `current_balance` decimal(15,2) DEFAULT '0.00',
  `is_active` tinyint(1) DEFAULT '1',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Dumping data for table `bank_accounts`
--

INSERT INTO `bank_accounts` (`id`, `name`, `bank_name`, `account_number`, `branch_name`, `iban`, `swift_code`, `opening_balance`, `current_balance`, `is_active`, `created_at`, `updated_at`) VALUES
(20, 'الحساب الرئيسي', 'بنك الكريمي', '53467864', 'فرع الصين', 'SAXXSKK', 'SMNASDNMS', 500000.00, 500000.00, 1, '2025-12-15 09:16:15', '2025-12-15 09:16:15');

-- --------------------------------------------------------

--
-- Stand-in structure for view `bank_account_balances`
-- (See below for the actual view)
--
DROP VIEW IF EXISTS `bank_account_balances`;
CREATE TABLE IF NOT EXISTS `bank_account_balances` (
`account_number` varchar(100)
,`bank_name` varchar(255)
,`current_balance` decimal(38,2)
,`id` int
,`name` varchar(255)
);

-- --------------------------------------------------------

--
-- Table structure for table `cash_boxes`
--

DROP TABLE IF EXISTS `cash_boxes`;
CREATE TABLE IF NOT EXISTS `cash_boxes` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `description` text,
  `opening_balance` decimal(15,2) DEFAULT '0.00',
  `current_balance` decimal(15,2) DEFAULT '0.00',
  `is_active` tinyint(1) DEFAULT '1',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Dumping data for table `cash_boxes`
--

INSERT INTO `cash_boxes` (`id`, `name`, `description`, `opening_balance`, `current_balance`, `is_active`, `created_at`, `updated_at`) VALUES
(7, 'صندوق رقم 1', '', 2000.00, 2000.00, 1, '2025-12-15 09:22:26', '2025-12-15 09:22:26');

-- --------------------------------------------------------

--
-- Stand-in structure for view `cash_box_balances`
-- (See below for the actual view)
--
DROP VIEW IF EXISTS `cash_box_balances`;
CREATE TABLE IF NOT EXISTS `cash_box_balances` (
`current_balance` decimal(38,2)
,`description` text
,`id` int
,`name` varchar(255)
);

-- --------------------------------------------------------

--
-- Table structure for table `companies`
--

DROP TABLE IF EXISTS `companies`;
CREATE TABLE IF NOT EXISTS `companies` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `phone` varchar(20) DEFAULT NULL,
  `address` text,
  `opening_balance` decimal(15,2) DEFAULT '0.00',
  `current_balance` decimal(15,2) DEFAULT '0.00',
  `is_active` tinyint(1) DEFAULT '1',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Dumping data for table `companies`
--

INSERT INTO `companies` (`id`, `name`, `phone`, `address`, `opening_balance`, `current_balance`, `is_active`, `created_at`, `updated_at`) VALUES
(7, 'دون شركب', '5548653', 'تعز المفرق', 1500.00, 25800.00, 1, '2025-12-15 12:24:23', '2025-12-16 01:18:38');

-- --------------------------------------------------------

--
-- Stand-in structure for view `company_balances`
-- (See below for the actual view)
--
DROP VIEW IF EXISTS `company_balances`;
CREATE TABLE IF NOT EXISTS `company_balances` (
`address` text
,`current_balance` decimal(38,2)
,`id` int
,`name` varchar(255)
,`phone` varchar(20)
);

-- --------------------------------------------------------

--
-- Table structure for table `currencies`
--

DROP TABLE IF EXISTS `currencies`;
CREATE TABLE IF NOT EXISTS `currencies` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `code` varchar(3) NOT NULL,
  `symbol` varchar(10) DEFAULT NULL,
  `exchange_rate` decimal(15,6) NOT NULL,
  `is_default` tinyint(1) DEFAULT '0',
  `is_active` tinyint(1) DEFAULT '1',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Dumping data for table `currencies`
--

INSERT INTO `currencies` (`id`, `name`, `code`, `symbol`, `exchange_rate`, `is_default`, `is_active`, `created_at`, `updated_at`) VALUES
(1, 'الريال السعودي', 'SAR', 'SAR', 0.530000, 0, 1, '2025-12-01 21:16:47', '2025-12-11 02:24:28'),
(2, 'الدولار الأمريكي', 'USD', '$', 0.140000, 0, 1, '2025-12-01 21:16:47', '2025-12-11 02:23:28'),
(3, 'الرينمنبي', 'CNY', '¥', 1.000000, 1, 1, '2025-12-01 21:16:47', '2025-12-11 02:25:22');

-- --------------------------------------------------------

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
CREATE TABLE IF NOT EXISTS `customers` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `phone` varchar(20) DEFAULT NULL,
  `address` text,
  `opening_balance` decimal(15,2) DEFAULT '0.00',
  `current_balance` decimal(15,2) DEFAULT '0.00',
  `is_active` tinyint(1) DEFAULT '1',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Dumping data for table `customers`
--

INSERT INTO `customers` (`id`, `name`, `phone`, `address`, `opening_balance`, `current_balance`, `is_active`, `created_at`, `updated_at`) VALUES
(12, 'احمد العامري', '784173938', 'تعز الحوبان', 5000.00, 80385.00, 1, '2025-12-15 12:23:08', '2025-12-16 01:18:38');

-- --------------------------------------------------------

--
-- Stand-in structure for view `customer_balances`
-- (See below for the actual view)
--
DROP VIEW IF EXISTS `customer_balances`;
CREATE TABLE IF NOT EXISTS `customer_balances` (
`address` text
,`current_balance` decimal(38,2)
,`id` int
,`name` varchar(255)
,`phone` varchar(20)
);

-- --------------------------------------------------------

--
-- Table structure for table `invoices`
--

DROP TABLE IF EXISTS `invoices`;
CREATE TABLE IF NOT EXISTS `invoices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `invoice_number` varchar(100) NOT NULL,
  `customer_id` int NOT NULL,
  `currency_id` int NOT NULL,
  `exchange_rate` decimal(15,6) NOT NULL,
  `office_commission` decimal(5,2) DEFAULT '0.00',
  `shipping_costs` decimal(15,2) DEFAULT '0.00',
  `certificate_costs` decimal(15,2) DEFAULT '0.00',
  `container_number` varchar(100) DEFAULT NULL,
  `total_amount` decimal(15,2) DEFAULT '0.00',
  `total_amount_local` decimal(15,2) DEFAULT '0.00',
  `status` enum('draft','confirmed','cancelled') DEFAULT 'draft',
  `notes` text,
  `created_by` int NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `invoice_number` (`invoice_number`),
  KEY `currency_id` (`currency_id`),
  KEY `created_by` (`created_by`),
  KEY `idx_invoices_customer_id` (`customer_id`)
) ENGINE=MyISAM AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Dumping data for table `invoices`
--

INSERT INTO `invoices` (`id`, `invoice_number`, `customer_id`, `currency_id`, `exchange_rate`, `office_commission`, `shipping_costs`, `certificate_costs`, `container_number`, `total_amount`, `total_amount_local`, `status`, `notes`, `created_by`, `created_at`, `updated_at`) VALUES
(19, 'INV-2025-12-0005', 12, 3, 1.000000, 20.00, 0.00, 0.00, NULL, 12000.00, 12000.00, 'draft', NULL, 1, '2025-12-16 01:17:55', '2025-12-16 01:18:38'),
(18, 'INV-2025-12-0004', 12, 3, 1.000000, 5.00, 0.00, 0.00, NULL, 7875.00, 7875.00, 'draft', NULL, 1, '2025-12-16 01:13:31', '2025-12-16 01:13:53'),
(17, 'INV-2025-12-0003', 12, 3, 1.000000, 5.00, 0.00, 0.00, NULL, 0.00, 0.00, 'draft', NULL, 1, '2025-12-16 01:13:29', '2025-12-16 01:13:29'),
(15, 'INV-2025-12-0001', 12, 3, 1.000000, 200.00, 200.00, 200.00, NULL, 4900.00, 4900.00, 'draft', NULL, 1, '2025-12-15 12:25:03', '2025-12-15 12:30:30'),
(16, 'INV-2025-12-0002', 12, 3, 1.000000, 10.00, 0.00, 0.00, NULL, 11000.00, 11000.00, 'draft', NULL, 1, '2025-12-16 00:46:22', '2025-12-16 01:06:02'),
(20, 'INV-2025-12-0006', 12, 3, 1.000000, 0.00, 0.00, 0.00, NULL, 0.00, 0.00, 'draft', NULL, 1, '2025-12-16 21:38:25', '2025-12-16 21:38:25');

-- --------------------------------------------------------

--
-- Table structure for table `invoice_audit`
--

DROP TABLE IF EXISTS `invoice_audit`;
CREATE TABLE IF NOT EXISTS `invoice_audit` (
  `id` int NOT NULL AUTO_INCREMENT,
  `invoice_id` int NOT NULL,
  `action` varchar(50) NOT NULL,
  `old_values` json DEFAULT NULL,
  `new_values` json DEFAULT NULL,
  `changed_by` int NOT NULL,
  `changed_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `invoice_id` (`invoice_id`),
  KEY `changed_by` (`changed_by`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `invoice_exchange_rates`
--

DROP TABLE IF EXISTS `invoice_exchange_rates`;
CREATE TABLE IF NOT EXISTS `invoice_exchange_rates` (
  `id` int NOT NULL AUTO_INCREMENT,
  `invoice_id` int NOT NULL,
  `currency_id` int NOT NULL,
  `exchange_rate` decimal(15,6) NOT NULL,
  `is_local` tinyint(1) DEFAULT '0',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq_invoice_currency` (`invoice_id`,`currency_id`),
  KEY `currency_id` (`currency_id`)
) ENGINE=MyISAM AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Dumping data for table `invoice_exchange_rates`
--

INSERT INTO `invoice_exchange_rates` (`id`, `invoice_id`, `currency_id`, `exchange_rate`, `is_local`, `created_at`) VALUES
(13, 19, 3, 1.000000, 1, '2025-12-16 01:17:55'),
(12, 15, 2, 0.150000, 0, '2025-12-15 12:25:03'),
(11, 15, 1, 0.500000, 0, '2025-12-15 12:25:03'),
(10, 15, 3, 1.000000, 1, '2025-12-15 12:25:03'),
(14, 19, 1, 0.530000, 0, '2025-12-16 01:17:55'),
(15, 19, 2, 0.140000, 0, '2025-12-16 01:17:55'),
(16, 20, 3, 1.000000, 1, '2025-12-16 21:38:25'),
(17, 20, 1, 0.500000, 0, '2025-12-16 21:38:25'),
(18, 20, 2, 0.150000, 0, '2025-12-16 21:38:25');

-- --------------------------------------------------------

--
-- Table structure for table `invoice_items`
--

DROP TABLE IF EXISTS `invoice_items`;
CREATE TABLE IF NOT EXISTS `invoice_items` (
  `id` int NOT NULL AUTO_INCREMENT,
  `invoice_id` int NOT NULL,
  `item_id` int NOT NULL,
  `company_id` int DEFAULT NULL,
  `quantity` decimal(15,3) NOT NULL,
  `unit_price` decimal(15,2) NOT NULL,
  `total_price` decimal(15,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `weight_id` int DEFAULT NULL,
  `carton_id` int DEFAULT NULL,
  `cbm_id` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`),
  KEY `idx_invoice_items_invoice_id` (`invoice_id`),
  KEY `idx_invoice_items_item_id` (`item_id`),
  KEY `idx_invoice_items_weight_key` (`weight_id`),
  KEY `idx_invoice_items_carton_key` (`carton_id`),
  KEY `idx_invoice_items_cbm_key` (`cbm_id`)
) ENGINE=MyISAM AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Dumping data for table `invoice_items`
--

INSERT INTO `invoice_items` (`id`, `invoice_id`, `item_id`, `company_id`, `quantity`, `unit_price`, `total_price`, `created_at`, `weight_id`, `carton_id`, `cbm_id`) VALUES
(25, 19, 9, 7, 10.000, 1000.00, 10000.00, '2025-12-16 01:18:16', NULL, NULL, NULL),
(24, 18, 8, 0, 5.000, 1500.00, 7500.00, '2025-12-16 01:13:53', NULL, NULL, NULL),
(23, 16, 8, 7, 5.000, 2000.00, 10000.00, '2025-12-16 00:46:44', NULL, NULL, NULL),
(21, 15, 8, 7, 2.000, 1450.00, 2900.00, '2025-12-15 12:25:39', NULL, NULL, NULL),
(22, 15, 9, 7, 2.000, 700.00, 1400.00, '2025-12-15 12:30:30', NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `items`
--

DROP TABLE IF EXISTS `items`;
CREATE TABLE IF NOT EXISTS `items` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `image` varchar(500) DEFAULT NULL,
  `default_price` decimal(15,2) DEFAULT '0.00',
  `model` varchar(100) DEFAULT NULL,
  `specifications` text,
  `unit_id` int NOT NULL,
  `company_id` int DEFAULT NULL,
  `current_stock` decimal(15,3) DEFAULT '0.000',
  `is_active` tinyint(1) DEFAULT '1',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `unit_id` (`unit_id`),
  KEY `company_id` (`company_id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Dumping data for table `items`
--

INSERT INTO `items` (`id`, `name`, `image`, `default_price`, `model`, `specifications`, `unit_id`, `company_id`, `current_stock`, `is_active`, `created_at`, `updated_at`) VALUES
(7, 'بسكويت ابو ولد', '6937538cde642_1765233548.jpeg', 5000.00, '5785343', 'حالي قوي', 1, 4, 0.000, 1, '2025-12-05 21:21:42', '2025-12-08 22:39:08'),
(8, 'Gas Pressure Fryer', 'product_691ba4c15b9fb.jpg', 1450.00, 'MDXZ-25', 'Dimension:460*960*1230mm\r\nPacking Size:1030*510*1300mm\r\nCapacity:25L\r\nVolts:220V/50HZ\r\nGas: LPG or Natural Gas\r\nWorking pressure :0.08Mpa\r\nN/W:110kg', 1, 3, 0.000, 1, '2025-07-26 22:34:10', '2025-12-11 02:06:37'),
(9, 'Gas 4-Burner Range with Electric Oven', 'product_691ba444545e9.png', 701.00, 'GT-GR905ZA', 'Natural Gas or LPG\r\nDimension:800*900*920mm\r\nOven Dimension:550*680*270mm\r\nLPG2800-3700Pa: 2.1 kg/h\r\nNG2000-2500Pa:2.81 m3/H\r\nPower Supply:7.5x2+4.5x2+5.8KW', 1, 4, 0.000, 1, '2025-11-17 22:40:04', '2025-12-08 22:32:37');

-- --------------------------------------------------------

--
-- Table structure for table `roles`
--

DROP TABLE IF EXISTS `roles`;
CREATE TABLE IF NOT EXISTS `roles` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `permissions` json NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Dumping data for table `roles`
--

INSERT INTO `roles` (`id`, `name`, `permissions`, `created_at`) VALUES
(1, 'Admin', '{\"users\": [\"create\", \"read\", \"update\", \"delete\"], \"reports\": [\"read\"], \"invoices\": [\"create\", \"read\", \"update\", \"delete\"], \"companies\": [\"create\", \"read\", \"update\", \"delete\"], \"customers\": [\"create\", \"read\", \"update\", \"delete\"]}', '2025-12-01 21:16:47'),
(2, 'Accountant', '{\"reports\": [\"read\"], \"invoices\": [\"create\", \"read\", \"update\"], \"companies\": [\"create\", \"read\", \"update\"], \"customers\": [\"create\", \"read\", \"update\"]}', '2025-12-01 21:16:47'),
(3, 'Clerk', '{\"invoices\": [\"create\", \"read\"], \"companies\": [\"read\"], \"customers\": [\"read\"]}', '2025-12-01 21:16:47');

-- --------------------------------------------------------

--
-- Table structure for table `shared_cartons`
--

DROP TABLE IF EXISTS `shared_cartons`;
CREATE TABLE IF NOT EXISTS `shared_cartons` (
  `id` int NOT NULL AUTO_INCREMENT,
  `total_cartons` int NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `shared_cbm`
--

DROP TABLE IF EXISTS `shared_cbm`;
CREATE TABLE IF NOT EXISTS `shared_cbm` (
  `id` int NOT NULL AUTO_INCREMENT,
  `total_cbm` decimal(15,6) NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `shared_weights`
--

DROP TABLE IF EXISTS `shared_weights`;
CREATE TABLE IF NOT EXISTS `shared_weights` (
  `id` int NOT NULL AUTO_INCREMENT,
  `total_weight` decimal(15,3) NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `stock_transactions`
--

DROP TABLE IF EXISTS `stock_transactions`;
CREATE TABLE IF NOT EXISTS `stock_transactions` (
  `id` int NOT NULL AUTO_INCREMENT,
  `item_id` int NOT NULL,
  `type` enum('in','out') NOT NULL,
  `quantity` decimal(15,3) NOT NULL,
  `reference_type` enum('invoice','purchase','adjustment') NOT NULL,
  `reference_id` int NOT NULL,
  `notes` text,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_stock_transactions_item_id` (`item_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `transactions`
--

DROP TABLE IF EXISTS `transactions`;
CREATE TABLE IF NOT EXISTS `transactions` (
  `id` int NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `account_type` enum('customer','company','cash','bank') NOT NULL,
  `voucher_type` enum('receipt','payment') DEFAULT NULL,
  `account_id` int NOT NULL,
  `related_invoice_id` int DEFAULT NULL,
  `related_voucher_id` int DEFAULT NULL,
  `debit_amount` decimal(15,2) DEFAULT '0.00',
  `credit_amount` decimal(15,2) DEFAULT '0.00',
  `description` text,
  `balance_after` decimal(15,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `payment_method` enum('cash','bank') DEFAULT 'cash',
  `is_reversed` tinyint(1) DEFAULT '0',
  `reversed_at` timestamp NULL DEFAULT NULL,
  `reversed_by` int DEFAULT NULL,
  `cash_box_id` int DEFAULT NULL,
  `bank_account_id` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `related_invoice_id` (`related_invoice_id`),
  KEY `related_voucher_id` (`related_voucher_id`),
  KEY `idx_transactions_account` (`account_type`,`account_id`),
  KEY `idx_transactions_date` (`date`),
  KEY `reversed_by` (`reversed_by`),
  KEY `idx_transactions_voucher` (`voucher_type`,`related_voucher_id`),
  KEY `idx_transactions_cash_box` (`cash_box_id`),
  KEY `idx_transactions_bank_account` (`bank_account_id`)
) ENGINE=MyISAM AUTO_INCREMENT=126 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Dumping data for table `transactions`
--

INSERT INTO `transactions` (`id`, `date`, `account_type`, `voucher_type`, `account_id`, `related_invoice_id`, `related_voucher_id`, `debit_amount`, `credit_amount`, `description`, `balance_after`, `created_at`, `payment_method`, `is_reversed`, `reversed_at`, `reversed_by`, `cash_box_id`, `bank_account_id`) VALUES
(125, '2025-12-16', 'customer', NULL, 12, 19, NULL, 12000.00, 0.00, 'فاتورة مشتريات - رصيد مدين', 80385.00, '2025-12-16 01:18:38', 'cash', 0, NULL, NULL, NULL, NULL),
(124, '2025-12-16', 'company', NULL, 7, 19, NULL, 0.00, 10000.00, 'مستحق من فاتورة مشتريات', 25800.00, '2025-12-16 01:18:38', 'cash', 0, NULL, NULL, NULL, NULL),
(122, '2025-12-16', 'customer', NULL, 12, 18, NULL, 7875.00, 0.00, 'فاتورة مشتريات - رصيد مدين', 56385.00, '2025-12-16 01:13:53', 'cash', 0, NULL, NULL, NULL, NULL),
(120, '2025-12-16', 'company', NULL, 7, 16, NULL, 0.00, 10000.00, 'مستحق من فاتورة مشتريات', 15800.00, '2025-12-16 00:46:44', 'cash', 0, NULL, NULL, NULL, NULL),
(121, '2025-12-16', 'customer', NULL, 12, 16, NULL, 11000.00, 0.00, 'فاتورة مشتريات - رصيد مدين', 48510.00, '2025-12-16 01:06:02', 'cash', 0, NULL, NULL, NULL, NULL),
(114, '2025-12-15', 'company', NULL, 7, 15, NULL, 0.00, 2900.00, 'مستحق من فاتورة مشتريات', 9400.00, '2025-12-15 12:25:39', 'cash', 0, NULL, NULL, NULL, NULL),
(115, '2025-12-15', 'company', NULL, 7, 15, NULL, 5000.00, 0.00, 'إلغاء مستحق من فاتورة مشتريات', 4400.00, '2025-12-15 12:29:59', 'cash', 0, NULL, NULL, NULL, NULL),
(118, '2025-12-15', 'company', NULL, 7, 15, NULL, 0.00, 1400.00, 'مستحق من فاتورة مشتريات', 5800.00, '2025-12-15 12:30:30', 'cash', 0, NULL, NULL, NULL, NULL),
(117, '2025-12-15', 'customer', NULL, 12, 15, NULL, 4900.00, 0.00, 'فاتورة مشتريات - رصيد مدين', 27500.00, '2025-12-15 12:30:30', 'cash', 0, NULL, NULL, NULL, NULL),
(112, '2025-12-15', 'company', NULL, 7, 15, NULL, 0.00, 5000.00, 'مستحق من فاتورة مشتريات', 6500.00, '2025-12-15 12:25:16', 'cash', 0, NULL, NULL, NULL, NULL),
(110, '2025-12-15', 'company', NULL, 7, NULL, NULL, 0.00, 1500.00, 'رصيد افتتاحي', -1500.00, '2025-12-15 12:24:23', 'cash', 0, NULL, NULL, NULL, NULL),
(109, '2025-12-15', 'customer', NULL, 12, NULL, NULL, 5000.00, 0.00, 'رصيد افتتاحي', 5000.00, '2025-12-15 12:23:08', 'cash', 0, NULL, NULL, NULL, NULL),
(108, '2025-12-15', 'cash', 'receipt', 7, NULL, NULL, 2000.00, 0.00, 'رصيد افتتاحي للصندوق: صندوق رقم 1', 2000.00, '2025-12-15 09:22:26', 'cash', 0, NULL, NULL, NULL, NULL),
(107, '2025-12-15', 'bank', 'receipt', 20, NULL, NULL, 500000.00, 0.00, 'رصيد افتتاحي للحساب البنكي: الحساب الرئيسي', 500000.00, '2025-12-15 09:16:15', 'bank', 0, NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `units`
--

DROP TABLE IF EXISTS `units`;
CREATE TABLE IF NOT EXISTS `units` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `code` varchar(20) NOT NULL,
  `description` text,
  `is_active` tinyint(1) DEFAULT '1',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Dumping data for table `units`
--

INSERT INTO `units` (`id`, `name`, `code`, `description`, `is_active`, `created_at`) VALUES
(1, 'كرتون', 'CTN', 'وحدة الكرتون', 1, '2025-12-01 21:16:47'),
(2, 'صندوق', 'BOX', 'وحدة الصندوق', 1, '2025-12-01 21:16:47'),
(3, 'قطعة', 'PCS', 'وحدة القطعة', 1, '2025-12-01 21:16:47'),
(4, 'كيلوجرام', 'KG', 'وحدة الوزن', 1, '2025-12-01 21:16:47'),
(5, 'متر مكعب', 'CBM', 'وحدة الحجم', 1, '2025-12-01 21:16:47');

-- --------------------------------------------------------

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
CREATE TABLE IF NOT EXISTS `users` (
  `id` int NOT NULL AUTO_INCREMENT,
  `username` varchar(50) NOT NULL,
  `email` varchar(50) NOT NULL,
  `password` varchar(255) NOT NULL,
  `role_id` int NOT NULL,
  `is_active` tinyint(1) DEFAULT '1',
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `username` (`username`),
  UNIQUE KEY `email` (`email`),
  KEY `role_id` (`role_id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Dumping data for table `users`
--

INSERT INTO `users` (`id`, `username`, `email`, `password`, `role_id`, `is_active`, `created_at`, `updated_at`) VALUES
(1, 'admin', 'admin@shipping.com', '$2y$10$.Dd/RtwoffoNqNi4hOC1duPsPp7hn7ulsDpz4HqoiVv0N0niTZID6', 1, 1, '2025-12-01 21:16:47', '2025-12-01 21:17:12'),
(2, 'accountant', 'accountant@shipping.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 2, 1, '2025-12-01 21:16:47', '2025-12-01 21:16:47'),
(3, 'clerk', 'clerk@shipping.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 3, 1, '2025-12-01 21:16:47', '2025-12-01 21:16:47');

-- --------------------------------------------------------

--
-- Table structure for table `vouchers`
--

DROP TABLE IF EXISTS `vouchers`;
CREATE TABLE IF NOT EXISTS `vouchers` (
  `id` int NOT NULL AUTO_INCREMENT,
  `voucher_number` varchar(100) NOT NULL,
  `type` enum('receipt','payment') NOT NULL,
  `amount` decimal(15,2) NOT NULL,
  `currency_id` int NOT NULL,
  `exchange_rate` decimal(15,6) NOT NULL,
  `related_to` enum('customer','company','cash','bank') NOT NULL,
  `related_id` int NOT NULL,
  `cash_box_id` int DEFAULT NULL,
  `bank_account_id` int DEFAULT NULL,
  `description` text,
  `created_by` int NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `payment_type` enum('cash','bank','both') DEFAULT 'cash',
  `voucher_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `reference_number` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `voucher_number` (`voucher_number`),
  KEY `currency_id` (`currency_id`),
  KEY `created_by` (`created_by`),
  KEY `cash_box_id` (`cash_box_id`),
  KEY `bank_account_id` (`bank_account_id`),
  KEY `idx_vouchers_date` (`voucher_date`),
  KEY `idx_vouchers_type` (`type`),
  KEY `idx_vouchers_related` (`related_to`,`related_id`)
) ENGINE=MyISAM AUTO_INCREMENT=30 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `voucher_exchange_rates`
--

DROP TABLE IF EXISTS `voucher_exchange_rates`;
CREATE TABLE IF NOT EXISTS `voucher_exchange_rates` (
  `id` int NOT NULL AUTO_INCREMENT,
  `voucher_id` int NOT NULL,
  `currency_id` int NOT NULL,
  `exchange_rate` decimal(15,6) NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq_voucher_currency` (`voucher_id`,`currency_id`),
  KEY `currency_id` (`currency_id`)
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Structure for view `bank_account_balances`
--
DROP TABLE IF EXISTS `bank_account_balances`;

DROP VIEW IF EXISTS `bank_account_balances`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `bank_account_balances`  AS SELECT `ba`.`id` AS `id`, `ba`.`name` AS `name`, `ba`.`bank_name` AS `bank_name`, `ba`.`account_number` AS `account_number`, coalesce((sum(`t`.`debit_amount`) - sum(`t`.`credit_amount`)),0) AS `current_balance` FROM (`bank_accounts` `ba` left join `transactions` `t` on(((`t`.`account_type` = 'bank') and (`t`.`account_id` = `ba`.`id`) and (`t`.`is_reversed` = 0)))) GROUP BY `ba`.`id`, `ba`.`name`, `ba`.`bank_name`, `ba`.`account_number` ;

-- --------------------------------------------------------

--
-- Structure for view `cash_box_balances`
--
DROP TABLE IF EXISTS `cash_box_balances`;

DROP VIEW IF EXISTS `cash_box_balances`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `cash_box_balances`  AS SELECT `cb`.`id` AS `id`, `cb`.`name` AS `name`, `cb`.`description` AS `description`, coalesce((sum(`t`.`debit_amount`) - sum(`t`.`credit_amount`)),0) AS `current_balance` FROM (`cash_boxes` `cb` left join `transactions` `t` on(((`t`.`account_type` = 'cash') and (`t`.`account_id` = `cb`.`id`) and (`t`.`is_reversed` = 0)))) GROUP BY `cb`.`id`, `cb`.`name`, `cb`.`description` ;

-- --------------------------------------------------------

--
-- Structure for view `company_balances`
--
DROP TABLE IF EXISTS `company_balances`;

DROP VIEW IF EXISTS `company_balances`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `company_balances`  AS SELECT `comp`.`id` AS `id`, `comp`.`name` AS `name`, `comp`.`phone` AS `phone`, `comp`.`address` AS `address`, coalesce((sum(`t`.`credit_amount`) - sum(`t`.`debit_amount`)),0) AS `current_balance` FROM (`companies` `comp` left join `transactions` `t` on(((`t`.`account_type` = 'company') and (`t`.`account_id` = `comp`.`id`) and (`t`.`is_reversed` = 0)))) GROUP BY `comp`.`id`, `comp`.`name`, `comp`.`phone`, `comp`.`address` ;

-- --------------------------------------------------------

--
-- Structure for view `customer_balances`
--
DROP TABLE IF EXISTS `customer_balances`;

DROP VIEW IF EXISTS `customer_balances`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `customer_balances`  AS SELECT `c`.`id` AS `id`, `c`.`name` AS `name`, `c`.`phone` AS `phone`, `c`.`address` AS `address`, coalesce((sum(`t`.`debit_amount`) - sum(`t`.`credit_amount`)),0) AS `current_balance` FROM (`customers` `c` left join `transactions` `t` on(((`t`.`account_type` = 'customer') and (`t`.`account_id` = `c`.`id`) and (`t`.`is_reversed` = 0)))) GROUP BY `c`.`id`, `c`.`name`, `c`.`phone`, `c`.`address` ;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
